/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.storage;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.config.ICommonConfiguration;
import mod.chiselsandbits.storage.IMultiThreadedStorageEngine;
import mod.chiselsandbits.storage.IStorageEngine;
import mod.chiselsandbits.storage.IStorageHandler;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

final class MultiThreadAwareStorageEngine
implements IMultiThreadedStorageEngine {
    private static ExecutorService saveService;
    private final IStorageEngine internalEngine;

    private static synchronized void ensureThreadPoolSetup() {
        if (saveService == null) {
            ClassLoader classLoader = ChiselsAndBits.class.getClassLoader();
            AtomicInteger genericThreadCounter = new AtomicInteger();
            saveService = Executors.newFixedThreadPool(ICommonConfiguration.getInstance().getBlockSaveThreadCount().get(), runnable -> {
                Thread thread = new Thread(runnable);
                thread.setContextClassLoader(classLoader);
                thread.setName(String.format("Chisels and Bits Block save handler #%s", genericThreadCounter.incrementAndGet()));
                thread.setDaemon(true);
                return thread;
            });
        }
    }

    MultiThreadAwareStorageEngine(IStorageEngine internalEngine) {
        this.internalEngine = internalEngine;
    }

    @Override
    public void serializeNBTInto(class_2487 tag) {
        this.internalEngine.serializeNBTInto(tag);
    }

    @Override
    public class_2487 serializeNBT() {
        return (class_2487)this.internalEngine.serializeNBT();
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.internalEngine.deserializeNBT(nbt);
    }

    @Override
    public void serializeInto(@NotNull class_2540 packetBuffer) {
        this.internalEngine.serializeInto(packetBuffer);
    }

    @Override
    public void deserializeFrom(@NotNull class_2540 packetBuffer) {
        this.internalEngine.deserializeFrom(packetBuffer);
    }

    @Override
    public Collection<? extends IStorageHandler> getHandlers() {
        return this.internalEngine.getHandlers();
    }

    @Override
    public CompletableFuture<Void> serializeOffThread(Function<class_2487, CompletableFuture<Void>> resultSaver) {
        MultiThreadAwareStorageEngine.ensureThreadPoolSetup();
        return CompletableFuture.supplyAsync(this::serializeNBT, saveService).thenComposeAsync(resultSaver);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        MultiThreadAwareStorageEngine.ensureThreadPoolSetup();
        saveService.execute(command);
    }
}

